﻿using System.Collections.Generic;
using System.Data;

namespace VeteransAffairs.Registries.BusinessManager
{
    public class PatientImagingManager : BaseBO
    {
        private readonly ImagingService _imagingService;
        private readonly PatientImageRepository _patientImageRepository;

        public PatientImagingManager()
        {
            _imagingService = new ImagingService();
            _patientImageRepository = new PatientImageRepository();
        }

        public static IEnumerable<string> LoadReferenceImageFragmentSizes()
        {
            return PatientImageRepository.LoadReferenceImageFragmentSizes();
        }

        public PatientImageAnalysis GetPatientImageAnalysis(string patientIcn)
        {
            return _patientImageRepository.GetPatientImageAnalysis(patientIcn);
        }

        public string GetBodyPartsImaged(int patientImageId)
        {
            return _patientImageRepository.GetBodyPartsImaged(patientImageId);
        }

        public int DeleteImageAnalysis(string patientIcn)
        {
            var eventArgs = new BOSaveSuccessEventArgs { SaveStatusArg = SaveStatus.SaveFail };

            int result = _patientImageRepository.DeleteImageAnalysis(patientIcn);

            eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;

            RaiseSaveEvent(this, eventArgs);

            return result;
        }

        public int InsertUpdateImageAnalysis(object[] parameters)
        {
            var eventArgs = new BOSaveSuccessEventArgs { SaveStatusArg = SaveStatus.SaveFail };

            int result = _patientImageRepository.InsertUpdateImageAnalysis(parameters);

            eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;

            RaiseSaveEvent(this, eventArgs);

            return result;
        }

        public bool ImageAnalysisHistoryExists(string patientIcn)
        {
            return _patientImageRepository.ImageAnalysisHistoryExists(patientIcn);
        }

        public DataTable GetPatientImagesDataTable(string patientIcn)
        {
            return _patientImageRepository.GetPatientImagesDataTable(patientIcn);
        }

        public bool ShouldRefreshImageData(int patientId)
        {
            return _patientImageRepository.ShouldRefreshImageData(patientId);
        }

        public void RefreshImageData(string patientIcn, int patientId)
        {
            _imagingService.InsertUpdatePatientStudies(patientIcn, patientId);
        }

        public bool ServicesAvailable(int patientId)
        {
            return _imagingService.ServicesAvailable(patientId);
        }
    }
}